/* worker variables for Wave 1 only */

libname tz 'd:\tanzrped\sasdata';
libname cd 'd:\tanzrped\createdata';


data allow1; set tz.tz1new;

/* need to take allowances from firm level data as these 
questions were not asked of workers in wave 1 */

/* clothing is excluded from allowance calc as only some worker
categories receive; other allowances tend to be common */

firm=key;
emp=v2401f+v2401p;

food=v2610a;
house=v2610b;
cloth=v2610c;
trans=v2610d;
bonus=v2610e/12;

allow=food+house+trans+bonus;

/* dummy variables */
mfood=v250107a;
mhouse=v250107b;
mcloth=v250107c;
mtrans=v250107d;
mbonus=v250107e;

pfood=v250607a;
phouse=v250607b;
pcloth=v250607c;
ptrans=v250607d;
pbonus=v250607e;

capallow=allow/emp;
capfood=food/emp;
caphouse=house/emp;
capcloth=cloth/emp;
captrans=trans/emp;
capbonus=bonus/emp;


keep key firm emp food house cloth trans bonus
mfood mhouse mcloth mtrans mbonus
pfood phouse pcloth ptrans pbonus
capfood caphouse capcloth captrans capbonus capallow allow;

proc means; run;
/* 
proc print; var firm emp capfood caphouse capcloth captrans 
capbonus capallow; run;
*/

data cd.work1; merge tz.wk1new allow1; by key;

options linesize=80;
options nolabel;

firm=key;
wave=1;
year=1;
wid=wnb_1;

if wid=. then delete;

ethnic=ori_1;
/* excludes 4 europeans and 3 others from analysis */
if ethnic=2 then delete;
if ethnic=4 then delete;

sex=sex_1;
age=age_1;
married=marr_1;

agesch=agesch_1;
diff=age-agesch;
yrendsc=1993-diff;

/* education variables - sorting out problems of
questionnaire coding structure */
edlevela=edu1_1;
if edlevela=9 then edlevela=10;
if edlevela=4 then alevel=1; else alevel=0;
if edlevela=5 then edlevela=4;
if alevel=1 then edlevela=5;

edlevelb=edu2_1;
if edlevelb=7 then edlevelb=9;
if edlevelb=6 then edlevelb=7;

edtype=efor_1;
edform=efnb_1;

if edlevela=1 then educ=0;
if edlevela=2 then educ=7;
if yrendsc lt 1964 and edlevela=2 then educ=4;
if edlevela=3 then educ=8;
if edlevela=4 then educ=11;
if edlevela=5 then educ=13;

if edtype=1 then years=edform;
if edtype=2 then years=edform+7;
if edtype=2 and edlevela=3 then years=edform+8;

if educ=. then educ=years;
if years lt educ and years ne . then educ=years;

if edlevelb=7 then educ=9;
if edlevelb=8 then educ=14;
if edlevelb=9 then educ=13;
if edlevelb=9 and edlevela=2 then educ=9;
if edlevelb=9 and edtype=1 then educ=9;

if edlevela=10 then educ=16;

/* imputed education levels */

yrborn=1993-age;
impeduc=yrendsc-yrborn-6;
if impeduc<educ then impeduc=educ;
if impeduc>30 then impeduc=educ;

/* calculation of consistent tenure variable */
years=nby_1;
months=nbm_1;
if months=. then months=0;
if years=. then years=0;
pcyear=months/12;
tenure=years+pcyear;

othfirm=work_1;

work=age-agesch;

/* if tenure>(work+1) and work ne . then tenure=work; */

/* make occupation categories in wave 1 consistent with other countries or
with other waves */

jobcat=jobn_1;

if jobcat=1 then occupat=1;
if jobcat=2 and educ gt 12 then occupat=5;
if jobcat=2 and educ lt 13 then occupat=7;
if jobcat=3 then occupat=9;
if jobcat=4 then occupat=14;
if jobcat=5 then occupat=13;
if jobcat=6 then occupat=15;
if jobcat=7 then occupat=16;
if jobcat=8 then occupat=12;
if jobcat=9 then occupat=11;
if jobcat=10 then occupat=13;
if jobcat=11 then occupat=19;
if jobcat=12 then occupat=18;

/* sorting out occupation category problems in tz1new data file */

if firm=210 then delete;
/* exclude owners from management category */
if firm=69 and wid=1 then delete;
if firm=205 and wid=1 then delete;
if firm=69 and wid=1 then delete;

if occupat=1 or occupat=2 then ocdum='amgmt';
if occupat=3 or occupat=4 then ocdum='badmin';
if occupat=5 or occupat=6 then ocdum='badmin';
if occupat=7 then ocdum='cleric';
if occupat=9 or occupat=10 then ocdum='csales';
if occupat=12 then ocdum='dsuper';
if occupat=13 or occupat=14 then ocdum='etech';
if occupat=8 or occupat=11 or occupat=15 then ocdum='fprod';
if occupat=16 or occupat=17 or occupat=19 then ocdum='fprod';
if occupat=18 then ocdum='gappren';

if occupat=1 or occupat=2 then mgmt=1; else mgmt=0;
if occupat=3 or occupat=4 or occupat=5 or occupat=6 then admin=1;
else admin=0;
if occupat=7 then cleric=1; else cleric=0;
if occupat=9 or occupat=10 then sales=1; else sales=0;
if occupat=12 then super=1; else super=0;
if occupat=13 or occupat=14 then tech=1; else tech=0;
if occupat=8 or occupat=11 or occupat=15
or occupat=16 or occupat=17 or occupat=19 then prod=1; else prod=0;
if occupat=18 then appren=1; else appren=0;


paid=payn_1;


/* no information on whether wage is net or
gross of tax (assume gross salary) or of value of allowances received */

tunit=salnu_1;
wagebt=saln_1;

if tunit=1 then delete;
if tunit=2 then wagebt=wagebt*22;
if tunit=3 then wagebt=wagebt*4;
if tunit=4 then wagebt=wagebt;
if tunit=5 then wagebt=wagebt/12;

wagebtst=salb_1;
tunitb=salbu_1;

if tunitb=1 then delete;
if tunitb=2 then wagebtst=wagebtst*22;
if tunitb=3 then wagebtst=wagebtst*4;
if tunitb=4 then wagebtst=wagebtst;
if tunitb=5 then wagebtst=wagebtst/12;

/* allowances */
if capallow=. then capallow=0;
if capfood=. then capfood=0;
if caphouse=. then caphouse=0;
if capcloth=. then capcloth=0;
if captrans=. then captrans=0;
if capbonus=. then capbonus=0;

check1=capfood/wagebt;
check2=caphouse/wagebt;
check3=capcloth/wagebt;
check4=captrans/wagebt;
check5=capbonus/wagebt;

/* managers allowances */
if ocdum='amgmt' then mger=1; else mger=0;

if mger=1 and mfood=1 then mfa=capfood; else mfa=0;
if mger=1 and mhouse=1 then mha=wagebt/10; else mha=0;
if mger=1 and mtrans=1 then mta=captrans; else mta=0;
if mger=1 and mbonus=1 then mba=wagebt/12; else mba=0;

if mger=1 then earn=wagebt+mfa+mha+mta+mba;
check=earn/wagebt;

if mger=0 and pfood=1 then pfa=capfood; else pfa=0;
if mger=0 and pcloth=1 then pca=capcloth; else pca=0;
if mger=0 and ptrans=1 then pta=captrans; else pta=0;
if mger=0 and pbonus=1 then pba=capbonus; else pba=0;

if mger=0 then earn=wagebt+pfa+pca+pta+pba;
check=earn/wagebt;

/* allocate workers with allowances 2 sds from mean
the mean value */

allow=earn-wagebt;
pcallow=allow/earn;

if pcallow gt (0.1567020+0.1577838*2) then pcallow=0.1567020;
allow=earn*pcallow;
earn=wagebt+allow;

/* excludes workers paid by piece rate or from firm
profits if no wage figure is given */
if wagebt=. and paid=3 then delete;
if wagebt=. and paid=2 then delete;


hours=hours_1;

train=trotj_1;
if train=2 then train=3;
if trout_1=1 then train=2;
trainn=train;


keep firm wave year wid ethnic sex age married yrborn impeduc
agesch yrendsc edlevela edlevelb edform tenure othfirm
occupat ocdum paid tunit earn wagebt wagebtst allow pcallow hours trainn educ
capfood caphouse capcloth captrans capbonus
mgmt admin cleric sales super tech prod appren;

proc means; run;
proc sort; by firm wid;


/* consistency checks run on data */

/* 
data check1; set cd.work1;
if ocdum ne 'amgmt' and wagebt>40000;
proc sort; by ocdum;
proc print; var firm wid educ earn wagebt; by ocdum; run;

data check2; set cd.work1;
if ocdum='badmi';
if wagebt<=10000;
years=agesch-6;
if years<educ;
proc print; var firm wid edlevela edlevelb educ years agesch; run;
proc print; var firm wid wagebt ocdum earn paid age educ; run;

data check3; set cd.work1;
work=age-agesch;
if work=. then delete;
/*if tenure>work and work ne . then tenure=work; */
/*if tenure=. then tenure=work; */
/* if tenure>work and work ne .;
proc print; var firm wid tenure work age agesch othfirm; run;


data check4; set cd.work1;
allow=earn-wagebt;
pcallow=allow/earn;
if pcallow gt (0.1567020+0.1577838) then delete;
proc means; run;
/* 


/* earnings function for wave 1 */

/*
data earnfc1; set cd.work1;

agesq=age*age;
expsq=tenure*tenure;

lwage=log(wagebt);

proc reg; model lwage=age agesq educ tenure mgmt admin
sales cleric super tech;
run;


data earnfc1a; set cd.work1;

agesq=age*age;
expsq=tenure*tenure;

learn=log(earn);

proc reg; model learn=age agesq educ tenure mgmt admin
sales cleric super tech;
run;
/*


/* earnings functions including firm characteristics */
/*
data temp5; set cd.owner1;
if union=2 then union=0;
if union92=2 then union92=0;

proc sort; by firm;
proc means; run;

data temp6; set cd.size1;

proc means; run;
proc sort; by firm;

data earn6; merge cd.work1 temp5 temp6; by firm;

proc means; run;
/*


/* EARNINGS */
/*
data earnfc6a; set earn6;

agesq=age*age;
expsq=tenure*tenure;

learn=log(earn);
lemp=log(emp);

proc reg; model learn=age agesq educ tenure mgmt admin
sales cleric super tech state sstate sfor anyfor tzown lemp;
run;

proc reg; model learn=age agesq educ tenure mgmt admin
sales cleric super tech asian african mideast other;
run;

proc reg; model learn=age agesq educ tenure mgmt admin
sales cleric super tech lemp;
run;

proc reg; model learn=age agesq educ tenure mgmt admin
sales cleric super tech food text wood;
run;
/*

/* WAGES */
/*
data earnfc6; set earn6;

agesq=age*age;
expsq=tenure*tenure;

lwage=log(wagebt);
lemp=log(emp);

proc reg; model lwage=age agesq educ tenure mgmt admin
sales cleric super tech state sstate sfor anyfor tzown;
run;

proc reg; model lwage=age agesq educ tenure mgmt admin
sales cleric super tech asian african mideast other;
run;

proc reg; model lwage=age agesq educ tenure mgmt admin
sales cleric super tech;
run;

proc reg; model lwage=age agesq educ tenure mgmt admin
sales cleric super tech food text wood;
run;
*/